<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/vod_list_screen.php';
require_once 'Dunehd_movie.php';

class DunehdVodListScreen extends VodListScreen
{
    public static function get_media_url_str($page_name, $arg = null)
    {
        $arr['screen_id'] = self::ID;
        $arr['page_name'] = $page_name;
        if ($page_name === 'search')
            $arr['pattern'] = $arg;
        else if ($page_name === 'genres')
            $arr['genre_id'] = $arg;
        else if ($page_name === 'collection')
            $arr['movie_id'] = $arg;
        else if ($page_name === 'seasons')
            $arr['movie_id'] = $arg;
        return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    private $session;
	private $vod;

    public function __construct($session, Vod $vod)
    {
        parent::__construct($vod);

        $this->session = $session;
		$this->vod = $vod;
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_page_for_ndx($ndx, $page_size)
    {
        return intval($ndx / $page_size) + 1;
    }

    protected function get_short_movie_range(MediaURL $media_url, $from_ndx,
        &$plugin_cookies)
    {
        hd_print("####### get_short_movie_range");
        $nums = 24;
        $page = $this->get_page_for_ndx($from_ndx, $nums);
		$lastyear = date("Y")-1;
        if ($media_url->page_name === 'last')
            //$doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, '>'.date("Y").'-1', null, null);
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, '>'.$lastyear, null, null);
        else if ($media_url->page_name === 'all')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, null, null, null);
        else if ($media_url->page_name === 'search')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, $media_url->pattern, null, null, "1,5,6");
        else if ($media_url->page_name === 'genres')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, $media_url->genre_id, null, null, null, null, null);
        else if ($media_url->page_name === 'serials')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, null, null, 6);
        else if ($media_url->page_name === 'collections')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, null, null, 5);
        else if ($media_url->page_name === 'collection')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, null, null, null, $media_url->movie_id);
        else if ($media_url->page_name === 'seasons')
            $doc = $this->session->api_get_list_movie($page, $nums, 0, null, null, null, null, null, null, $media_url->movie_id);
        else
            throw new Exception('Vod list: invalid page name.');

        $cnt = $doc->options->count;

		if ($doc->groups->item->title == "No video subscribe")
            return new ShortMovieRange(0, 0);

        if (empty($cnt))
            throw new Exception('Invalid data returned from server');
        $total = intval($cnt);
        if ($total === 0)
            return new ShortMovieRange(0, 0);

        $from_ndx = (intval($doc->options->page) - 1) * $nums;

        $movies = array();
        foreach ($doc->groups->item as $row)
        {
            $icon_url = strval($row->pic); // . Dunehd::$SERVER . $row->poster;
            $movies[] = new DunehdShortMovie(
                intval($row->id), strval($row->title), $icon_url, intval($row->type));
        }

        return new ShortMovieRange($from_ndx, $total, $movies);
    }

    public function get_folder_range(MediaURL $media_url, $from_ndx, &$plugin_cookies)
    {
        $movie_range = $this->get_short_movie_range(
            $media_url, $from_ndx, $plugin_cookies);

        $total = intval($movie_range->total);
        if ($total <= 0)
            return HD::create_regular_folder_range(array());

        $items = array();
        foreach ($movie_range->short_movies as $movie)
        {
            $items[] = array
            (
                PluginRegularFolderItem::media_url =>
                    DunehdVodMovieScreen::get_media_url_str($movie->id),
                PluginRegularFolderItem::caption => $movie->name,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $movie->poster_url,
                )
            );

            $this->vod->set_cached_short_movie(
                new DunehdShortMovie($movie->id, $movie->name, $movie->poster_url, $movie->movie_type));
        }

        return HD::create_regular_folder_range(
            $items, $movie_range->from_ndx, $total);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
