﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/tv/tv_group_list_screen.php';

///////////////////////////////////////////////////////////////////////////

class DunehdTvGroupListScreen extends TvGroupListScreen implements UserInputHandler
{
	private $session = NULL;
	
    public function __construct($tv, $folder_views, $session)
    {
        parent::__construct($tv, $folder_views);
		$this->session = $session;
        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_handler_id()
	{
		return self::ID;
	}

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		$quality_action = UserInputHandlerRegistry::create_action($this, 'quality_select');
		$quality_action['caption'] = $this->session->translate('key_quality');
		$server_action = UserInputHandlerRegistry::create_action($this, 'server_select');
		$server_action['caption'] = $this->session->translate('key_server');
		$timeshift_action = UserInputHandlerRegistry::create_action($this, 'timeshift_select');
		$timeshift_action['caption'] = $this->session->translate('key_timeshift');

        return array
        (
            GUI_EVENT_KEY_ENTER => ActionFactory::open_folder(),
            GUI_EVENT_KEY_PLAY  => ActionFactory::tv_play(),
			GUI_EVENT_KEY_B_GREEN => $quality_action,
			GUI_EVENT_KEY_C_YELLOW => $server_action,
			GUI_EVENT_KEY_D_BLUE => $timeshift_action,
        );
    }

    ///////////////////////////////////////////////////////////////////////

    public function handle_user_input(&$user_input, &$plugin_cookies)
	{
        hd_print('DunehdTvGroupListScreen: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");
			
		if($user_input->control_id == 'quality_select')
		{
			if ($this->session->get_quality() === null)
				$this->session->api_get_quality();
				
            $defs = array();          
			$quality_ops = array();
			$quality = isset($plugin_cookies->quality) ? $plugin_cookies->quality : 'mq';
			foreach($this->session->get_quality()->groups->item as $pair)
				if(isset($this->session->quality_names[strval($pair->name)]))
					$quality_ops[strval($pair->code)] = strval($this->session->quality_names[strval($pair->name)]);
				
			ControlFactory::add_combobox($defs, $this, null,
            'quality_id', $this->session->translate('select_value'), $quality, $quality_ops, 0,
            false, false);
			ControlFactory::add_close_dialog_and_apply_button($defs,
				$this, null,
				'quality_ok_id', 'OK', 200);
		
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range($this->get_all_folder_items($parent_media_url, $plugin_cookies));
					
			return array
			(
				GuiAction::handler_string_id => SHOW_DIALOG_ACTION_ID,
				GuiAction::caption => null,
				GuiAction::data =>
					array
					(
						ShowDialogActionData::title => $this->session->translate('translation_quality'),
						ShowDialogActionData::defs => $defs,
						ShowDialogActionData::timer => null,
						ShowDialogActionData::actions => array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run(ActionFactory::update_regular_folder($range, true))),
						ShowDialogActionData::close_by_return => true,
						ShowDialogActionData::preferred_width => 0,
					),
				GuiAction::params => null,
			);

		}
		elseif($user_input->control_id == 'server_select')
		{
			if ($this->session->get_settings() === null)
				$this->session->api_get_settings();
				
            $defs = array();          
			$stream_server_ops = array();
			$stream_server = intval($this->session->get_settings()->media_server_id);
			foreach ($this->session->get_settings()->media_servers->item as $pair)
				$stream_server_ops[intval($pair->id)] = strval($pair->title);
				
			ControlFactory::add_combobox($defs, $this, null,
            'media_server_id', $this->session->translate('select_value'), $stream_server, $stream_server_ops, 0,
            false, false);
			ControlFactory::add_close_dialog_and_apply_button($defs,
				$this, null,
				'server_ok_id', 'OK', 200);
		
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range($this->get_all_folder_items($parent_media_url, $plugin_cookies));
					
			return array
			(
				GuiAction::handler_string_id => SHOW_DIALOG_ACTION_ID,
				GuiAction::caption => null,
				GuiAction::data =>
					array
					(
						ShowDialogActionData::title => $this->session->translate('translation_server'),
						ShowDialogActionData::defs => $defs,
						ShowDialogActionData::timer => null,
						ShowDialogActionData::actions => array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run(ActionFactory::update_regular_folder($range, true))),
						ShowDialogActionData::close_by_return => true,
						ShowDialogActionData::preferred_width => 0,
					),
				GuiAction::params => null,
			);

		}
		elseif($user_input->control_id == 'timeshift_select')
		{
			if ($this->session->get_settings() === null)
				$this->session->api_get_settings();
				
            $defs = array();          
			$timeshift_ops = array();
			for($i=0; $i<25; $i++)
				$timeshift_ops[$i] = $i;
				
			ControlFactory::add_combobox($defs, $this, null,
				'timeshift_id', $this->session->translate('select_value'), intval($this->session->get_settings()->time_shift), $timeshift_ops, 0,
				false, false);
			ControlFactory::add_close_dialog_and_apply_button($defs,
				$this, null,
				'timeshift_ok_id', 'OK', 200);
		
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range($this->get_all_folder_items($parent_media_url, $plugin_cookies));
					
			return array
			(
				GuiAction::handler_string_id => SHOW_DIALOG_ACTION_ID,
				GuiAction::caption => null,
				GuiAction::data =>
					array
					(
						ShowDialogActionData::title => $this->session->translate('key_timeshift'),
						ShowDialogActionData::defs => $defs,
						ShowDialogActionData::timer => null,
						ShowDialogActionData::actions => array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run(ActionFactory::update_regular_folder($range, true))),
						ShowDialogActionData::close_by_return => true,
						ShowDialogActionData::preferred_width => 0,
					),
				GuiAction::params => null,
			);

		}
		else if($user_input->control_id == 'quality_ok_id')	
		{
			$plugin_cookies->quality = $user_input->quality_id;
			$this->tv->unload_channels();
			return ActionFactory::invalidate_folders(array($user_input->parent_media_url));
		}
		else if($user_input->control_id == 'server_ok_id')	
		{
			try
			{
				$this->session->api_set_setting('media_server_id', $user_input->media_server_id);
				$this->session->api_get_settings();
			}
			catch (DuneException $e)
			{
				return $e->get_error_action();
			}
		}
		else if($user_input->control_id == 'timeshift_ok_id')	
		{
			try
			{
				$this->session->api_set_setting('time_shift', $user_input->timeshift_id);
				$this->session->api_get_settings();
			}
			catch (DuneException $e)
			{
				return $e->get_error_action();
			}
		}
		
		return null;
		
	}

}

///////////////////////////////////////////////////////////////////////////
?>
