﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/hashed_array.php';
require_once 'lib/tv/abstract_tv.php';
require_once 'lib/tv/default_epg_item.php';
require_once 'lib/tv/epg_iterator.php';


require_once 'Dunehd_channel.php';

///////////////////////////////////////////////////////////////////////////

class DunehdTv extends AbstractTv
{
    private $session;

    public function __construct($session)
    {
        $this->session = $session;
        parent::__construct(
            AbstractTv::MODE_CHANNELS_N_TO_M,
            DunehdConfig::TV_FAVORITES_SUPPORTED,
            true);
    }

    public function get_fav_icon_url()
    {
        return DunehdConfig::FAV_CHANNEL_GROUP_ICON_PATH;
    }

    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    public function unload_channels()
    {
        $this->channels = null;
        $this->groups = null;
    }
	
    protected function ____load_channels(&$plugin_cookies)
    {
        if (!isset($plugin_cookies->login) || !isset($plugin_cookies->pass))
        {
               hd_print("Error: Authorization required!!!");
               return ;
        }
        try
        {

           $this->session->check_for_arch();
            $this->load_channels_($plugin_cookies);
        }
        catch (Exception $e)
        {
            hd_print("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }

    }

    protected function load_channels(&$plugin_cookies)
    {
        $this->session->check_for_arch();
        $this->session->check_logged_in();

		if($this->session->get_account_info() == null)
			$this->session->api_get_account_info();
		$no_archives = strpos($this->session->get_account_info()->subscriptions->item->title, 'Эконом') !== false;

        $xml = $this->session->api_get_groups_tv();

        $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;


        $this->channels = new HashedArray();
        $this->groups = new HashedArray();
		
        if ($this->is_favorites_supported())
        {
            $this->groups->put(
                new FavoritesGroup(
                    $this,
                    '__favorites',
                    $this->translate('favorites_group'),
                    DunehdConfig::FAV_CHANNEL_GROUP_ICON_PATH));
        }

        $this->groups->put(
            new AllChannelsGroup(
                $this,
				$this->translate('all_channels_group'),
                DunehdConfig::ALL_CHANNEL_GROUP_ICON_PATH));


        foreach ($xml->groups->children() as $xml_tv_category)//gruppi
        {
            if ($xml_tv_category->getName() !== 'item')
            {
                hd_print("Error: unexpected node '" . $xml_tv_category->getName() .
                    "'. Expected: 'item'");
                throw new Exception('Invalid XML document');
            }

			$_group_name = strval($xml_tv_category->user_title);
			if(empty($_group_name))
				$_group_name = strval($xml_tv_category->name);
            $this->groups->put(
                new DefaultGroup(
                    strval($xml_tv_category->id),
                    $_group_name,
                    DunehdConfig::TV_CHANNEL_GROUP_ICON_PATH . strval($xml_tv_category->alias) . ".png"));
        }
		// deutch (id=50)
		/*
		$this->groups->put(
			new DefaultGroup(
				50,
				"Немецкие",
				DunehdConfig::TV_CHANNEL_GROUP_ICON_PATH . "german.png"));

		*/
        $xml = $this->session->api_get_channels_tv($plugin_cookies);
		$chnum = 1;
        foreach ($xml->groups->children() as $xml_tv_group)
        {
			foreach ($xml_tv_group->channels->children() as $xml_tv_channel)
			{
				if ($xml_tv_channel->getName() !== 'item')
				{
					hd_print("Error: unexpected node '" . $xml_tv_channel->getName() .
						"'. Expected: 'item'");
					throw new Exception('Invalid XML document');
				}


				$channel =
					new DunehdChannel(
						intval($xml_tv_channel->id),
						strval($xml_tv_channel->name),
						$this->session->get_channel_icon(intval($xml_tv_channel->id)),
						"",
						$chnum++,
						intval($xml_tv_channel->number),
						14,
						2,
						$buf_time,
						intval($xml_tv_channel->protected) == 1,
						$no_archives ? 0 : intval($xml_tv_channel->has_archive),
						intval($xml_tv_channel->is_video));

				$this->channels->put($channel);

				//$channeltmp = intval($xml_tv_channel->group_id);
				/*
				if ( $xml_tv_channel->audiotrack_default == "deu" )
				{
					$tv_category_id = 50;
				}
				else
				*/
				
				$tv_category_id = intval($xml_tv_channel->group_id);

				$group = $this->groups->get($tv_category_id);

				// Link group and channel.
				$channel->add_group($group);
				$group->add_channel($channel);
			}
        }
		
		// remove empty groups
		$temp_groups = new HashedArray();
		foreach($this->get_groups() as $g)
			if($g->is_favorite_channels() or ($g->get_channels($plugin_cookies) != NULL and $g->get_channels($plugin_cookies)->size()))
				$temp_groups->put($g);
			else
				hd_print("Group " . $g->get_title() . " removed: no channels");
		$this->groups = $temp_groups;

		// sort channels in group all-channels
		$this->get_group('__all_channels')->get_channels($plugin_cookies)->usort("cmp_channels");
		
		// restore numbers
		$chnum = 1;
		foreach($this->channels as $c)
		{
			//hd_print($c->get_id() . " " . $c->get_number() . " " . $c->get_title());
			$c->set_number($chnum++);
		}
    }

    public function get_tv_info(MediaURL $media_url, &$plugin_cookies)
    {
        $this->session->ensure_logged_in($plugin_cookies);

        return parent::get_tv_info($media_url, &$plugin_cookies);
    }

///////////////////////////////////////////////////////////////////////////
    public function get_tv_playback_url($channel_id, $archive_ts, $protect_code, &$plugin_cookies)
    {
        $this->ensure_channels_loaded($plugin_cookies);

        $cid = $this->get_channel($channel_id)->get_id();
        $cc = $this->get_channel($channel_id)->is_video();
        hd_print("---> is_video: $cc, is_protected: " . $this->get_channel($channel_id)->is_protected());
        $this->session->check_for_arch();
        #TODO:2
		
		if($this->get_channel($channel_id)->is_protected() && $protect_code == '')
		{
			hd_print("No protect code supplied for protected channel");
			throw new DuneException(
					'No protect code supplied for protected channel', 99,
					ActionFactory::show_error(false, 'No protect code supplied for protected channel', array()));
		}
		
        hd_print("--->>> channel:$cid, archive:$archive_ts, protect:$protect_code");
        if (0) // ( $cc == 0 )
        {
            $radio = $cid - 1000;
            $xml = $this->session->get_url_radio($radio);
            $tmp = urldecode($xml->url);
        }
        else
        {
            $xml = $this->session->api_get_url_tv($cid,$archive_ts,$protect_code, $plugin_cookies);
            if (intval($archive_ts) < 0)
            {
                $tmp = str_ireplace("http://", "http://ts://", $xml->url);
            }
            else
            {
                $tmp = str_ireplace("http://", "http://ts://127.0.0.1:1000/cgi-bin/arch?http://", $xml->url);
            }
        }
        #$tmp = str_ireplace("http://", "http://ts://", $xml->url);
        hd_print("_____tmp $tmp");
        #TODO:3
        $url = $tmp;
        hd_print("--->>> URL: $url");

        return $url;
    }

    ///////////////////////////////////////////////////////////////////////////

    public function get_day_epg_iterator($channel_id, $day_start_ts, &$plugin_cookies)
    {
        $epg = array();

        hd_print("--->>> day_start_ts: $day_start_ts");
        #использовалось с api 0.7
        #$day = HD::format_timestamp($day_start_ts, "ymd");


        $cc = $this->get_channel($channel_id)->is_video();
        if ($cc == 0)
        {
            $epg[] =
                new DefaultEpgItem(
                    "ТВ Программа отсутствует",
                    "",//strval($epg_item->description),
                    "",//intval($epg_item->begin),
                    0/*intval($epg_item->stop_time)*/);
        }
        else
        {
            $xml = $this->session->api_get_epg($day_start_ts, $channel_id);
            if ($xml->channels->item->getName() !== 'item')
            {
                $epg[] =
                    new DefaultEpgItem(
                        "ТВ Программа отсутствует",
                        "",//strval($epg_item->description),
                        "",//intval($epg_item->begin),
                        0/*intval($epg_item->stop_time)*/);
            }


            else
            {

                foreach ($xml->channels->item->epg->children() as $epg_item)
                {
                    if ($epg_item->getName() !== 'item')
                    {
                        hd_print("Error: unexpected node '" . $epg_item->getName() ."'. Expected: 'item'");
                        throw new Exception('Invalid XML document');
                    }
                    else
                    {
                        $epg[] =
                            new DefaultEpgItem(
                                strval($epg_item->title),
                                strval($epg_item->info),
                                intval($epg_item->begin),
                                0/*intval($epg_item->stop_time)*/);
                    }
                }
            }

        }
        return new EpgIterator(
            $epg,
            $day_start_ts,
            $day_start_ts + 86400);
    }
    ///////////////////////////////////////////////////////////////////////////
    // Hook for adding special group items.
    public function add_special_groups(&$items)
    {
        $lang = $this->session->get_dune_lang();
        array_unshift($items,
            array
            (
                PluginRegularFolderItem::media_url =>
                MediaURL::encode(
                    array
                    (
                        'screen_id' => DunehdVodRootScreen::ID,
                    )),
                PluginRegularFolderItem::caption => $this->translate('vod_group'),
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => 'plugin_file://icons/videotheka.png'
//                    $this->session->get_icon('mov_root.png')
                )
            ));
            
    }
	
    public function get_archive(MediaURL $media_url)
    { 
        return $this->session->get_archive(); 
    }
	
	public function translate($key)
	{
		return $this->session->translate($key);
	}
}

function cmp_channels($a, $b)
{
    if ($a->get_order() == $b->get_order()) {
        return 0;
    }
    return ($a->get_order() < $b->get_order()) ? -1 : 1;
}
?>
