<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_controls_screen.php';

///////////////////////////////////////////////////////////////////////////

class DunehdSetupScreen extends AbstractControlsScreen
{
    const ID = 'setup';
    const VERSION = ' Rus.TV';
    private $session;
    private $pcode = null;
	private $tv;

    ///////////////////////////////////////////////////////////////////////

    public function __construct($session, $tv)
    {
        parent::__construct(self::ID);

        $this->session = $session;
        $this->tv = $tv;
    }

    public function do_get_control_defs(&$plugin_cookies)
    {
        $defs = array();

        $plugin_dir = DuneSystem::$properties['install_dir_path'];
        $xml = simplexml_load_file($plugin_dir . '/dune_plugin.xml');
        $this->add_label($defs,$this->tv->translate('version'), strval($xml->version) . self::VERSION);

        $user_name = isset($plugin_cookies->user_name) ? $plugin_cookies->user_name : '';
        $logged_in = $this->session->is_logged_in();

        $unset = $this->tv->translate('<no>');
        if ($logged_in)
        {
            $account_info = $this->session->get_account_info();
            if (empty($account_info))
            {
                $this->session->api_get_account_info();
                $account_info = $this->session->get_account_info();
            }
            $subscription = $account_info->subscriptions->item;

            $settings = $this->session->get_settings();
            if (empty($settings))
            {
                $this->session->api_get_settings();
                $settings = $this->session->get_settings();
            }
			if ($this->session->get_quality() === null)
				$this->session->api_get_quality();
			
        }
        else
            $subscription = null;

        $login_error = $this->session->get_login_error();


        if ($user_name == '')
            $login_str = $unset;
        else if (!$logged_in && !empty($login_error))
            $login_str = $login_error;
        else if (!$logged_in || empty($subscription) || empty($subscription->title))
            $login_str = $user_name;
        else
            $login_str = $user_name . ' (' .  $subscription->title . ')';

        if (empty($subscription->end_date))
            $end_date = $unset;
        else
            $end_date = strval($subscription->end_date);

        $this->add_label($defs, $this->tv->translate('subscription'), $login_str);
        $this->add_label($defs, $this->tv->translate('expires'), $end_date);


        $this->add_button($defs, 'edit_subscription', null, $this->tv->translate('edit_subscription'), 0);

        if (!$logged_in)
            return $defs;

        $this->add_vgap($defs, 40);

        $show_tv = isset($plugin_cookies->show_tv) ?
            $plugin_cookies->show_tv : 'yes';
        $show_vod = isset($plugin_cookies->show_vod) ?
            $plugin_cookies->show_vod : 'yes';
            
        $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;

        $show_ops = array();
        $show_ops['yes'] = $this->tv->translate('yes');
        $show_ops['no'] = $this->tv->translate('no');

        $this->add_combobox($defs,
            'show_tv', $this->tv->translate('show_tv_in_main'),
            $show_tv, $show_ops, 0, true);

        $stream_server_ops = array();
        $stream_server = intval($settings->media_server_id);
        foreach ($settings->media_servers->item as $pair)
            $stream_server_ops[intval($pair->id)] = strval($pair->title);
        $this->add_combobox($defs,
            'media_server_id', $this->tv->translate('translation_server').':',
            $stream_server, $stream_server_ops, 0, true);

		$quality_ops = array();
		$quality = isset($plugin_cookies->quality) ? $plugin_cookies->quality : 'mq';
		foreach($this->session->get_quality()->groups->item as $pair)
			if(isset($this->session->quality_names[strval($pair->name)]))
				$quality_ops[strval($pair->code)] = strval($this->session->quality_names[strval($pair->name)]);
        $this->add_combobox($defs,
            'quality_id', $this->tv->translate('translation_quality').':',
            $quality, $quality_ops, 0, true);
		
        $this->pcode = strval($settings->parental_pass);
        hd_print("Current pcode: $this->pcode");

        $this->add_button($defs, 'edit_pcode', $this->tv->translate('parental_control').':',
            $this->tv->translate('change'), 0);

        $timeshift_ops = array();
		for($i=0; $i<25; $i++)
			$timeshift_ops[$i] = $i;

        $this->add_combobox($defs,
            'time_shift', $this->tv->translate('timeshift'),
            intval($settings->time_shift), $timeshift_ops, 0, true);

		return $defs;
    }

    private function do_get_edit_pcode_defs()
    {
        $defs = array();

        $this->add_text_field($defs,
            'current_pcode', $this->tv->translate('current_pcode'),
            '', true, true, false, false, 400);

        $this->add_text_field($defs,
            'new_pcode', $this->tv->translate('new_pcode'),
            $this->pcode, true, true, false, false, 400);

        $this->add_text_field($defs,
            'new_pcode_copy', $this->tv->translate('repeat_pcode'),
            $this->pcode, true, true, false, false, 400);

        $this->add_vgap($defs, 50);

        $this->add_button($defs,
            'apply_pcode', null, $this->tv->translate('set_new'), 300);

        $this->add_vgap($defs, -3);

        $this->add_close_dialog_button($defs,
            $this->tv->translate('cancel'), 300);

        return $defs;
    }

    private function do_get_edit_pcode_action()
    {
        return ActionFactory::show_dialog(
            $this->tv->translate('parental_control'),
            $this->do_get_edit_pcode_defs(),
            true);
    }

    public function get_control_defs(MediaURL $media_url, &$plugin_cookies)
    {
        hd_print("Setup::get_control_defs");
        foreach($media_url as $key => $val)
            hd_print("  MediaURL: $key => $val");

        try
        {
            if (!$this->session->is_login_incorrect())
                $this->session->ensure_logged_in($plugin_cookies, false);
        }
        catch (Exception $e)
        {
        }
        return $this->do_get_control_defs($plugin_cookies);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Setup: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");

        $need_close_dialog = false;
        $need_reset_controls = false;
        $post_action = null;
        $control_id = $user_input->control_id;

        if (isset($user_input->{$control_id}))
        {
            $new_value = $user_input->{$control_id};
            hd_print("Setup: changing $control_id value to $new_value");
        }
        else
            $new_value = null;

        if ($user_input->action_type === 'confirm')
        {
            if ($control_id === 'show_tv')
                $plugin_cookies->show_tv = $new_value;
            else if ($control_id === 'show_vod')
                $plugin_cookies->show_vod = $new_value;
            else if ($control_id == 'media_server_id')
            {
                try
                {
                    $this->session->api_set_setting($control_id, $new_value);
                }
                catch (DuneException $e)
                {
                    return $e->get_error_action();
                }
            }
			else if ($control_id == "quality_id")
			{
				$plugin_cookies->quality = $new_value;
				if($this->tv)
				{
					$this->tv->unload_channels();
					return ActionFactory::invalidate_folders(array('tv_group_list'));
				}
			}
            else if ($control_id == 'time_shift')
            {
                try
                {
                    $this->session->api_set_setting($control_id, $new_value);
                }
                catch (DuneException $e)
                {
                    return $e->get_error_action();
                }
            }
        }
        else if ($user_input->action_type === 'apply')
        {
            if ($control_id === 'edit_subscription')
            {
                return $this->session->do_get_edit_subscription_action(
                    $plugin_cookies, $this);
            }
            else if ($control_id === 'apply_subscription')
            {
                if ($user_input->user_name === '')
                {
                    return ActionFactory::show_error(false,
                        'Error',
                        array('Subscription should be non-empty.'));
                }

                $plugin_cookies->user_name = $user_input->user_name;
                $plugin_cookies->password = $user_input->password;

                $this->session->logout();

                try
                {
                    $this->session->try_login($plugin_cookies, false);
                }
                catch (DuneException $e)
                {
                    $post_action = $e->get_error_action();
                    return $post_action;
                }
                $need_close_dialog = true;
                $need_reset_controls = true;
            }
            else if ($control_id === 'edit_pcode')
            {
                return $this->do_get_edit_pcode_action();
            }
            else if ($control_id === 'apply_pcode')
            {
                if ($user_input->new_pcode != $user_input->new_pcode_copy)
                    return ActionFactory::show_error(false, 'Error', array($this->tv->translate('confirm_new_code')));
                if ($user_input->new_pcode == '')
                    return ActionFactory::show_error(false, 'Error', array($this->tv->translate('enter_new_code')));
                try
                {
                    $this->session->api_change_pcode(
                        $user_input->current_pcode,
                        $user_input->new_pcode);
                    $this->session->api_get_settings();
                }
                catch (DuneException $e)
                {
                    return $e->get_error_action();
                }
                $need_close_dialog = true;
                $need_reset_controls = true;
            }
        }
        if ($need_reset_controls)
        {
            $defs = $this->do_get_control_defs($plugin_cookies);

            $reset_controls_action = ActionFactory::reset_controls(
                $defs, $post_action);

            if ($need_close_dialog)
            {
                return ActionFactory::close_dialog_and_run(
                    $reset_controls_action);
            }

            return $reset_controls_action;
        }
        return null;
        #return ActionFactory::reset_controls(
        #    $this->do_get_control_defs($plugin_cookies));
    }


}

///////////////////////////////////////////////////////////////////////////
?>
