<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/default_dune_plugin.php';
require_once 'lib/default_archive.php';
require_once 'lib/action_factory.php';
require_once 'lib/control_factory.php';
require_once 'lib/dune_exception.php';
require_once 'lib/utils.php';
require_once 'lib/abstract_preloaded_regular_screen.php';
require_once 'lib/vod/vod_list_screen.php';
require_once 'lib/vod/vod_search_screen.php';
require_once 'lib/vod/vod_genres_screen.php';
require_once 'lib/vod/vod_series_list_screen.php';
require_once 'lib/vod/vod_favorites_screen.php';

require_once 'lib/tv/tv_group_list_screen.php';
require_once 'lib/tv/tv_channel_list_screen.php';
require_once 'lib/tv/tv_favorites_screen.php';

require_once 'Dunehd_exception.php';
require_once 'Dunehd_config.php';
require_once 'Dunehd_entry_handler.php';
require_once 'Dunehd_api.php';
require_once 'Dunehd_tv.php';
require_once 'Dunehd_tv_group_list_screen.php';
require_once 'Dunehd_setup_screen.php';
require_once 'Dunehd_vod.php';
require_once 'Dunehd_vod_root_screen.php';
require_once 'Dunehd_vod_list_screen.php';
require_once 'Dunehd_vod_movie_screen.php';


///////////////////////////////////////////////////////////////////////////

class DunehdPlugin extends DefaultDunePlugin
{
    private $session;
    private $entry_handler;

    public function __construct()
    {
        $this->session = new DunehdApi($this);
        $this->entry_handler = new DunehdEntryHandler($this->session);
        $this->tv = new DunehdTv($this->session);
        $this->vod = new DunehdVod($this->session);

        $tv_folder_views = $this->get_tv_folder_views();

        $this->add_screen(new DunehdSetupScreen($this->session, $this->tv));

        $this->add_screen(new DunehdTvGroupListScreen($this->tv,
            DunehdConfig::GET_TV_GROUP_LIST_FOLDER_VIEWS(), $this->session));
        $this->add_screen(new TvChannelListScreen($this->tv,
            DunehdConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));
        $this->add_screen(new TvFavoritesScreen($this->tv,
            DunehdConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));

        $this->add_screen(new DunehdVodRootScreen($this->session, $tv_folder_views));

        $this->add_screen(new DunehdVodListScreen($this->session, $this->vod));

        $this->add_screen(new DunehdVodMovieScreen($this->session, $this->vod));

        $this->add_screen(new VodSeriesListScreen($this->vod));

        $this->add_screen(new VodFavoritesScreen($this->vod));

        $this->add_screen(new VodSearchScreen($this->vod));

        $this->add_screen(new VodGenresScreen($this->vod));

    }

    ///////////////////////////////////////////////////////////////////////

    public function unset_login()
    {
        $this->session->unset_login();
        $this->tv->unload_channels();
        $this->vod->clear_movie_cache();
        $this->vod->clear_genre_cache();

        DefaultArchive::clear_cache();
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_tv_folder_views()
    {
        return DunehdConfig::GET_TV_GROUP_LIST_FOLDER_VIEWS();
    }
   
}

///////////////////////////////////////////////////////////////////////////
?>
