﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/user_input_handler_registry.php';

class DunehdEntryHandler
    implements UserInputHandler
{
    private $session;

    public function __construct($session)
    {
        $this->session = $session;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_handler_id()
    {
        return 'entry';
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('Entry handler: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");

        if (!isset($user_input->entry_id))
            return null;

        $add_params = array(
            'entry_id' => $user_input->entry_id);

        if ($user_input->entry_id === 'setup' || $user_input->entry_id === 'tv')
        {
            $res = $this->session->apply_subscription($plugin_cookies, $user_input);
            if ($res !== false)
            {
                if (!isset($res['action']))
                {
                    return ActionFactory::close_dialog_and_run(
                        ActionFactory::open_folder());
                }

                return $res['need_close_dialog'] ?
                    ActionFactory::close_dialog_and_run($res['action']) :
                    $res['action'];
            }
            else
            {
                if ($this->session->is_logged_in())
				{
					if($user_input->entry_id !== 'setup')
					{
						$check = $this->check_subscriptions();
						if($check !== false)
							return $check;
					}
                    return ActionFactory::open_folder();
				}
				
				if(!isset($plugin_cookies->user_name) || $plugin_cookies->user_name === '')
                {
                    return $this->session->do_get_edit_subscription_action(
                        $plugin_cookies, $this, $add_params);
                }

                if ($user_input->entry_id === 'setup')
                    return ActionFactory::open_folder();

                hd_print('Entry handler: handle_user_input: try_login');
                $post_action = null;
                try
                {
                    $this->session->try_login($plugin_cookies);					
					if($user_input->entry_id !== 'setup')
					{
						$check = $this->check_subscriptions();
						if($check !== false)
							return $check;
					}
                }
                catch (DuneException $e)
                {
                    hd_print('Entry handler: handle_user_input: exception - ' . $e->getMessage());
					if($e->getMessage() == 'Login failed.' && $user_input->entry_id === 'tv')
						return $this->session->do_get_edit_subscription_action(
							$plugin_cookies, $this, $add_params);
					
                    $post_action = $e->get_error_action();
                    return $post_action;
                }
                return ActionFactory::open_folder();
            }
        }

        return null;
    }
	
	private function check_subscriptions()
	{
		if($this->session->get_account_info() == null)
			$this->session->api_get_account_info();
			
		$defs = array();
		foreach($this->session->get_account_info()->subscriptions->item as $subscription)
			if($subscription->rest_of_days < 8 && intval($this->session->get_account_info()->balance) < 4)
				ControlFactory::add_label($defs, strval($subscription->title), strval($subscription->rest_of_days) . ' ' . $this->days($subscription->rest_of_days));			

		if(intval($this->session->get_account_info()->balance) == 0 && $subscription->rest_of_days < 8)
			ControlFactory::add_label($defs, "", $this->session->translate('subscription_extend'));		
		elseif(count($this->session->get_account_info()->subscriptions->item) == 0)
			ControlFactory::add_label($defs, "", $this->session->translate('subscription_stopped'));
		
		if(count($defs) > 0)
		{
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'suscription_check_ok_id', 'OK', 150, ActionFactory::open_folder());
				
			return ActionFactory::show_dialog(
							$this->session->translate('subscription_date'),
							$defs,
							true);
		}
		return false;
	}
	
	private function days($val)
	{
		if ($val == 1 || ($val % 10 == 1 && $val > 20)) return $this->session->translate('day');
		if ($val == 2 || ($val % 10 == 2 && $val > 20)) return $this->session->translate('two_days');
		if ($val == 3 || ($val % 10 == 3 && $val > 20)) return $this->session->translate('two_days');
		if ($val == 4 || ($val % 10 == 4 && $val > 20)) return $this->session->translate('two_days');
		return $this->session->translate('days');
	}
}

///////////////////////////////////////////////////////////////////////////
?>
