<?php

class DunehdConfig
{
    const VOD_MOVIE_PAGE_SUPPORTED = false;
    const VOD_FAVORITES_SUPPORTED  = false;
    const TV_FAVORITES_SUPPORTED   = true;


    const TV_CHANNEL_GROUP_ICON_PATH   = 'plugin_file://icons/';

    const ALL_CHANNEL_GROUP_CAPTION     = 'Все каналы';
    const ALL_CHANNEL_GROUP_ICON_PATH   = 'plugin_file://icons/all.png';

    const FAV_CHANNEL_GROUP_CAPTION     = 'Избранное';
    const FAV_CHANNEL_GROUP_ICON_PATH   = 'plugin_file://icons/fav.png';

    public static function get_str($lang, $key)
    {
        $def = 'ru';
        $res = self::$LANGS[$lang][$key];
        if(empty($res))
            $res = self::$LANGS[$def][$key];
        if(empty($res))
            $res = $key;
        return $res;
    }
    
    public static $LANGS = array(
    'ru' => array(
				'login'					=> 'Логин (номер подписки):',
				'password'				=> 'Пароль:',
				'enter'					=> 'Ввести',
				'cancel'				=> 'Отмена',
				'subscription_data'		=> 'Ввод данных подписки',
                'all_channels_group'    => 'Все каналы',
                'favorites_group'       => 'Избранное',
                'vod_group'             => 'Видеотека',
                'vod_all'               => 'Все фильмы',
                'vod_new'               => 'Новинки',
                'vod_collections'       => 'Сборники',
                'vod_search'            => 'Поиск',
                'vod_genres'            => 'Жанры',
                'vod_serials'           => 'Сериалы',
				'vod_seasons'			=> 'Сезоны',
				'vod_series'			=> 'Серии',
				'vod_movies'			=> 'Фильмы',
				'key_quality'			=> 'Качество',
				'key_server'			=> 'Сервер',
				'key_timeshift'			=> 'Сдвиг времени',
				'select_value'			=> 'Выберите значение:',
				'translation_quality'	=> 'Качество трансляции',
				'translation_server'	=> 'Сервер вещания',
				'add_to_favorites'		=> 'Добавить в Избранное',
				'already_in_favorites'	=> 'Фильм уже находится в Избранном',
				'added_to_favorites'	=> 'Фильм добавлен в Избранное',
				'removed_from_favorites'=> 'Фильм удалён из Избранного',
				'enter_movie_name'		=> 'Введите название фильма:',
				'err_pattern_is_empty'	=> 'Не заполнено поле поиска.',
				'delete'				=> 'Удалить',
				'delete_from_favorites'	=> 'Удалить из группы Избранное',
				'to_favorites'			=> 'В Избранное',
				'parental_code'			=> 'Родительский код:',
				'favorites_forward'		=> 'Вперёд',
				'favorites_backward'	=> 'Назад',
				'channel_in_favorites'	=> 'Канал уже находится в Избранном',
				'channel_added_to_favorites'	=> 'Канал добавлен в Избранное',
				
				// setup screen
				'version'				=> 'Версия',
				'<no>'					=> '<нет>',
				'no'					=> 'Нет',
				'yes'					=> 'Да',
				'subscription'			=> 'Подписка на пакеты:',
				'expires'				=> 'Истекает:',
				'edit_subscription'		=> 'Ввести подписку...',
				'show_tv_in_main'		=> 'Показывать TV в главном меню:',
				'parental_control'		=> 'Родительский контроль',
				'change'				=> 'Изменить...',
				'timeshift'				=> 'Сдвиг по времени, час:',
				'current_pcode'			=> 'Текущий код доступа:',
				'new_pcode'				=> 'Новый код:',
				'repeat_pcode'			=> 'Подтвердить новый код:',
				'set_new'				=> 'Сменить',
				'confirm_new_code'		=> 'Подтвердите новый код.',
				'enter_new_code'		=> 'Введите новый код.',
				'quality_low'			=> 'Низкое',
				'quality_default'		=> 'По умолчанию',
				'subscription_extend'	=> 'Пожалуйста, продлите действие Вашего абонемента',
				'subscription_stopped'	=> 'Ваш абонемент приостановлен, пожалуйста обратитесь в службу поддержки',
				'subscription_date'		=> 'Действие абонемента',
				'day'					=> 'День',
				'two_days'				=> 'Дня',
				'days'					=> 'Дней',				
				),
    'en' => array(
				'login'					=> 'Login (subscription number):',
				'password'				=> 'Password:',
				'enter'					=> 'Enter',
				'cancel'				=> 'Cancel',
				'subscription_data'		=> 'Enter subscription data',
                'all_channels_group'    => 'All channels',
                'favorites_group'       => 'Favorites',
                'vod_group'             => 'Videoteka',
                'vod_all'               => 'All movies',
                'vod_new'               => 'New',
                'vod_collections'       => 'Collections',
                'vod_search'            => 'Search',
                'vod_genres'            => 'Genres',
                'vod_serials'           => 'Serials',
				'vod_seasons'			=> 'Seasons',
				'vod_series'			=> 'Series',
				'vod_movies'			=> 'Movies',
				'key_quality'			=> 'Quality',
				'key_server'			=> 'Server',
				'key_timeshift'			=> 'Timeshift',
				'select_value'			=> 'Select value:',
				'translation_quality'	=> 'Quality',
				'translation_server'	=> 'Streaming server',
				'add_to_favorites'		=> 'Add to Favorites',
				'already_in_favorites'	=> 'Already in Favorites',
				'added_to_favorites'	=> 'Added to Favorites',
				'removed_from_favorites'=> 'Removed from Favorites',
				'enter_movie_name'		=> 'Enter movie name:',
				'err_pattern_is_empty'	=> 'Search pattern is empty.',
				'delete'				=> 'Remove',
				'delete_from_favorites'	=> 'Remove from Favorites',
				'to_favorites'			=> 'To Favorites',
				'parental_code'			=> 'Protect code:',
				'favorites_forward'		=> 'Forward',
				'favorites_backward'	=> 'Backward',
				'channel_in_favorites'	=> 'Channel is in Favorites',
				'channel_added_to_favorites'	=> 'Channel added to Favorites',

				// setup screen
				'version'				=> 'Version',
				'<no>'					=> '<no>',
				'no'					=> 'No',
				'yes'					=> 'Yes',
				'subscription'			=> 'Subscription packets:',
				'expires'				=> 'Expires:',
				'edit_subscription'		=> 'Enter subscription...',
				'show_tv_in_main'		=> 'Show TV in main menu:',
				'parental_control'		=> 'Parental control',
				'change'				=> 'Change...',
				'timeshift'				=> 'Timeshift, hours:',
				'current_pcode'			=> 'Current protect code:',
				'new_pcode'				=> 'New code:',
				'repeat_pcode'			=> 'Confirm new code:',
				'set_new'				=> 'Set new',
				'confirm_new_code'		=> 'Confirm new code.',
				'enter_new_code'		=> 'Enter new code.',
				'quality_low'			=> 'Low',
				'quality_default'		=> 'Default',
				'subscription_extend'	=> 'Please, extend your subscription',
				'subscription_stopped'	=> 'Subscription stopped, please contact support',
				'subscription_date'		=> 'Subscription active',
				'day'					=> 'day',
				'two_days'				=> 'days',
				'days'					=> 'days',
                ),
                
  'de' => array(
				'login'					=> 'Login:',
				'password'				=> 'Passwort:',
				'enter'					=> 'OK',
				'cancel'				=> 'Abbrechen',
				'subscription_data'		=> 'Abonnement',
                'all_channels_group'    => 'Alle Kannäle',
                'favorites_group'       => 'Favoriten',
                'vod_group'             => 'Filme',
                'vod_all'               => 'Alle Filme',
                'vod_new'               => 'Neue Filme',
                'vod_collections'       => 'Sammlungen',
                'vod_search'            => 'Suche',
                'vod_genres'            => 'Genres',
                'vod_serials'           => 'Serien',
				'vod_seasons'			=> 'Seasons',
				'vod_series'			=> 'Folgen',
				'vod_movies'			=> 'Filme',
				'key_quality'			=> 'Qualität',
				'key_server'			=> 'Server',
				'key_timeshift'			=> 'Timeshift',
				'select_value'			=> 'Auswahl:',
				'translation_quality'	=> 'Qualität',
				'translation_server'	=> 'Streaming Server',
				'add_to_favorites'		=> 'Zu Favoriten',
				'already_in_favorites'	=> 'Bereits in Favoritenliste',
				'added_to_favorites'	=> 'Hinzugefügt zu Favoritenliste',
				'removed_from_favorites'=> 'Entfernt aus Favoritenliste',
				'enter_movie_name'		=> 'Film Name eingeben:',
				'err_pattern_is_empty'	=> 'Suchmuster ist leer.',
				'delete'				=> 'Entfernen',
				'delete_from_favorites'	=> 'Entfernen aus Favoritenliste',
				'to_favorites'			=> 'zu Favoritenliste',
				'parental_code'			=> 'Jugendschutzkode:',
				'favorites_forward'		=> 'Vorwärts',
				'favorites_backward'	=> 'Rückwärts',
				'channel_in_favorites'	=> 'Kannal ist bereits in Favoritenliste',
				'channel_added_to_favorites'	=> 'Kannal ist zu Favoritenliste hinzugefügt',

				// setup screen
				'version'				=> 'Version',
				'<no>'					=> '<no>',
				'no'					=> 'Nein',
				'yes'					=> 'Ja',
				'subscription'			=> 'Abonnementinfo:',
				'expires'				=> 'Gültig bis:',
				'edit_subscription'		=> 'Abodaten bearbeiten...',
				'show_tv_in_main'		=> 'TV in Hauptmenu anzeigen:',
				'parental_control'		=> 'Jugendschutz',
				'change'				=> 'Ändern...',
				'timeshift'				=> 'Timeshift, Stunden:',
				'current_pcode'			=> 'Alter Kode:',
				'new_pcode'				=> 'Neuer Kode:',
				'repeat_pcode'			=> 'Neuer Kode wiederholen:',
				'set_new'				=> 'Ändern',
				'confirm_new_code'		=> 'Neuer Kode bestätigen.',
				'enter_new_code'		=> 'Neuer Kode eintreten....',
				'quality_low'			=> 'niedrig',
				'quality_default'		=> 'standard',
				'subscription_extend'	=> 'Bitte, verlängern Sie das Abonnement',
				'subscription_stopped'	=> 'Abo paused, bitte wenden Sie sich an den Support',
				'subscription_date'		=> 'Abo aktiv',
				'day'					=> 'Tag',
				'two_days'				=> 'Tage',
				'days'					=> 'Tage',
                ),
                
    'pl' => array(
				'login'					=> 'Login (abonament numer):',
				'password'				=> 'Parol:',
				'enter'					=> 'Wchodzić',
				'cancel'				=> 'Anuluj',
				'subscription_data'		=> 'Abonament',
                'all_channels_group'    => 'Wszyscy kanały',
                'favorites_group'       => 'Faworyt',
                'vod_group'             => 'Wideo',
                'vod_all'               => 'Wszyscy kino',
                'vod_new'               => 'Nowy',
                'vod_collections'       => 'Kolekcje',
                'vod_search'            => 'Wyszukaj',
                'vod_genres'            => 'Gatunki',
                'vod_serials'           => 'Seriali',
				'vod_seasons'			=> 'Sezon',
				'vod_series'			=> 'Seria',
				'vod_movies'			=> 'Kino',
				'key_quality'			=> 'Jakość',
				'key_server'			=> 'Serwer',
				'key_timeshift'			=> 'Timeshift',
				'select_value'			=> 'Wybierz wartość:',
				'translation_quality'	=> 'Jakość',
				'translation_server'	=> 'Streaming server',
				'add_to_favorites'		=> 'Dodaj do faworyt',
				'already_in_favorites'	=> 'Już w faworyt',
				'added_to_favorites'	=> 'Dodano do faworyt',
				'removed_from_favorites'=> 'Usunięte z faworyt',
				'enter_movie_name'		=> 'Wchodzić kino imię:',
				'err_pattern_is_empty'	=> 'Wzór jest pusty.',
				'delete'				=> 'Usunąć',
				'delete_from_favorites'	=> 'Usunąć z faworyt',
				'to_favorites'			=> 'Do faworyt',
				'parental_code'			=> 'Kod rodzicielska:',
				'favorites_forward'		=> 'Naprzód',
				'favorites_backward'	=> 'Wstecz',
				'channel_in_favorites'	=> 'Kanał jest w faworyt',
				'channel_added_to_favorites'	=> 'Kanał dodać do faworyt',

				// setup screen
				'version'				=> 'Wersja',
				'<no>'					=> '<no>',
				'no'					=> 'Nie',
				'yes'					=> 'Tak',
				'subscription'			=> 'Abonament:',
				'expires'				=> 'Wygasa:',
				'edit_subscription'		=> 'Wprowadź abonament...',
				'show_tv_in_main'		=> 'Pokaż TV w menu głównym:',
				'parental_control'		=> 'Kod rodzicielska',
				'change'				=> 'Zmiana...',
				'timeshift'				=> 'Timeshift, godzin:',
				'current_pcode'			=> 'Aktualna:',
				'new_pcode'				=> 'Nowy:',
				'repeat_pcode'			=> 'Potwierdzać:',
				'set_new'				=> 'Ustaw nowe',
				'confirm_new_code'		=> 'Potwierdź nowy kod.',
				'enter_new_code'		=> 'Wpisz nowy kod.',
				'quality_low'			=> 'Niski',
				'quality_default'		=> 'Standard',
				'subscription_extend'	=> 'Proszę, przedłużyć abonament',
				'subscription_stopped'	=> 'Abonament zatrzymany, skontaktuj się z obsługą',
				'subscription_date'		=> 'Abonament aktywny',
				'day'					=> 'dzień',
				'two_days'				=> 'dni',
				'days'					=> 'dni',
                ),
                
    'tr' => array(
				'login'					=> 'Login (abone numara):',
				'password'				=> 'Parola:',
				'enter'					=> 'Girmek',
				'cancel'				=> 'İptal',
				'subscription_data'		=> 'Girmek abone',
                'all_channels_group'    => 'Hepsi kanallar',
                'favorites_group'       => 'Favori',
                'vod_group'             => 'Video',
                'vod_all'               => 'Hepsi video',
                'vod_new'               => 'Yeni',
                'vod_collections'       => 'Koleksiyonlar',
                'vod_search'            => 'Aramak',
                'vod_genres'            => 'Türler',
                'vod_serials'           => 'Süreli',
				'vod_seasons'			=> 'Sezon',
				'vod_series'			=> 'Seri',
				'vod_movies'			=> 'Video',
				'key_quality'			=> 'Kaliteli',
				'key_server'			=> 'Sunucu',
				'key_timeshift'			=> 'Timeshift',
				'select_value'			=> 'Seç değer:',
				'translation_quality'	=> 'Kaliteli',
				'translation_server'	=> 'Akış sunucu',
				'add_to_favorites'		=> 'Favorilere ekle',
				'already_in_favorites'	=> 'Zaten favori olarak',
				'added_to_favorites'	=> 'Favori eklendi',
				'removed_from_favorites'=> 'Favori kaldır',
				'enter_movie_name'		=> 'Film adını girin:',
				'err_pattern_is_empty'	=> 'Arama deseni boş.',
				'delete'				=> 'Kaldır',
				'delete_from_favorites'	=> 'Favorilerden kaldır',
				'to_favorites'			=> 'Sık Kullanılanlara',
				'parental_code'			=> 'Kodu korumak:',
				'favorites_forward'		=> 'ileriye doğru',
				'favorites_backward'	=> 'geriye doğru',
				'channel_in_favorites'	=> 'Kanal sık olduğu',
				'channel_added_to_favorites'	=> 'Kanal favorilere eklendi',

				// setup screen
				'version'				=> 'Sürüm',
				'<no>'					=> '<no>',
				'no'					=> 'hayır',
				'yes'					=> 'Evet',
				'subscription'			=> 'Abone:',
				'expires'				=> 'sona ermek:',
				'edit_subscription'		=> 'Girmek abone...',
				'show_tv_in_main'		=> 'Ana menüde göster tv:',
				'parental_control'		=> 'Ebeveyn Kontrolü',
				'change'				=> 'Değişim...',
				'timeshift'				=> 'Timeshift, saat:',
				'current_pcode'			=> 'Güncel koruma kodu:',
				'new_pcode'				=> 'yeni kod:',
				'repeat_pcode'			=> 'Yeni kodu onayla:',
				'set_new'				=> 'yeni ayarlama',
				'confirm_new_code'		=> 'Yeni kodu onayla.',
				'enter_new_code'		=> 'Yeni kodu girin.',
				'quality_low'			=> 'Düşük',
				'quality_default'		=> 'Standart',
				'subscription_extend'	=> 'Senin abonnelik uzatmak Lütfen',
				'subscription_stopped'	=> 'Abonelik desteğine başvurun, durdu',
				'subscription_date'		=> 'aktif abonelik',
				'day'					=> 'gün',
				'two_days'				=> 'gün',
				'days'					=> 'gün',
                ),
    );
    ///////////////////////////////////////////////////////////////////////
    // Folder views.

    public static function GET_TV_GROUP_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_TOP,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_scale_factor => 0.8,
                    ViewItemParams::icon_sel_scale_factor => 0.9,
                    ViewItemParams::item_caption_sel_dy => 10,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_TOP,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                    ViewItemParams::icon_scale_factor => 1.2,
                    ViewItemParams::icon_sel_scale_factor => 1.35,
                    ViewItemParams::item_caption_sel_dy => 17,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

        );
    }

    public static function GET_TV_CHANNEL_LIST_FOLDER_VIEWS()
    {
        return array(
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    #ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                    #ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    #ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 2,
                    ViewParams::num_rows => 15,
                    ViewParams::paint_details => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 75,
                    ViewItemParams::icon_height => 43,
                    ViewItemParams::item_caption_width => 485,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            )

        );
    }

}

?>
