﻿<?php
///////////////////////////////////////////////////////////////////////////

require_once 'Dunehd_exception.php';
require_once 'lib/dune_exception.php';
require_once 'lib/action_factory.php';
require_once 'lib/control_factory.php';

const API_HOST = 'http://core.techno4us1pa.xyz/iptv/api/v1/xml/';

const ECODE_MALLFORMED_REPLAY = 101;
const ECODE_ERROR = 1;

const S_UNKNOWN	    = "UNKNOWN";
const S_BAD_NODE	= "BAD_NODE";
const S_BAD_REQ	    = "BAD_REQ";
const S_BAD_CMD	    = "BAD_CMD";
const S_WRONG_IP	= "WRONG_IP";
const S_WRONG_VALUE = "WRONG_VALUE";
const S_WRONG_PARAM = "WRONG_PARAM";
const S_BAD_PAIRS	= "BAD_PAIRS";
const S_FLD_EMPTY	= "FLD_EMPTY";
const S_ACC_WRONG	= "AСС_WRONG";
const S_ACC_EMPTY	= "AСС_EMPTY";
const S_ACC_WTYPE	= "AСС_WTYPE";
const S_ACC_NOSUB	= "ACC_NOSUB";
const S_STIMEOUT	= "STIMEOUT";
const S_BAD_SID	    = "BAD_SID";
const S_WRONG_SID	= "WRONG_SID";
const S_URL_NOT_FOUND   = "URL_NOT_FOUND";
const S_URL_PROTECTED   = "URL_PROTECTED";

const R_ARCHIVE_URL_PREFIX = 'http://update.techno4us1pa.xyz/dunehd/icons/';
const R_ARCHIVE_ID = 'main';

class DunehdApi
{
	private $sid = 0;
	private $is_logged = false;
    private $login_incorrect = false;
    private $user_name = null;
    private $last_error = null;
    private $login_error = null;
    private $account_info = null;
    private $settings = null;
	private $quality = null;
	private $plugin_cookies = null;
	private $lang = null;
	
	public $quality_names = null;

    private $unset_login_listener = null;

    public function __construct($unset_login_listener)
    {
        if (isset($unset_login_listener))
            $this->unset_login_listener = $unset_login_listener;
        else
            $this->unset_login_listener = $this;
			
		$this->update_dune_config();
		$this->quality_names = array('low' => $this->translate('quality_low'), 'middle' => $this->translate('quality_default'));
    }

	public function is_logged_in()
    	{ return $this->is_logged; }

    public function is_login_incorrect()
        { return $this->login_incorrect; }

    public function get_account_info()
        { return $this->account_info; }

    public function get_settings()
        { return $this->settings; }

	public function get_quality()
        { return $this->quality; }

    public function get_user_name()
        { return $this->user_name; }

    public function get_login_error()
        { return $this->login_error; }

    public function get_dune_lang()
        { return $this->lang; }

    public function unset_login()
    {
	/*
		$cmd = 'killall noop';
		hd_print("starting: $cmd");
		$s = shell_exec($cmd);
		if (!empty($s))
			hd_print("$cmd - $s");
	*/
		$this->is_logged = false;
        $this->login_incorrect = false;
        $this->sid = 0;
        $this->user_name = null;
        $this->account_info = null;
        $this->settings = null;
    }

    public function logout()
    {
        $this->unset_login_listener->unset_login();
    }

    public function get_icon($name)
    {
        return DunehdConfig::TV_CHANNEL_GROUP_ICON_PATH . $name;
    }

    public function get_channel_icon($channel_id)
    {
        $archive = DefaultArchive::get_archive(
            R_ARCHIVE_ID,
            R_ARCHIVE_URL_PREFIX);
			
		$url = $archive->get_archive_url("b$channel_id.png");
	//	hd_print("Icon requested : $url");
        return $url;
    }

    public function get_archive()
    {
        return DefaultArchive::get_archive(R_ARCHIVE_ID, R_ARCHIVE_URL_PREFIX);
    }
    ///////////////////////////////////////////////////////////////////////

    public function xml_fetch($url)
    {
		$attempts = 0;
		
	start:
		$this->last_error = null;
        $doc = HD::http_get_document($url);
    //    hd_print("--->>> get_xml: $doc");
        $xml = simplexml_load_string($doc);
        if (is_null($doc))
            throw new DunehdException('Invalid data received from server', ECODE_MALLFORMED_REPLAY);
        if ($xml === false)
        {
            hd_print("Error: can not parse XML document.");
            hd_print("XML-text: $doc.");
            throw new DunehdException('Illegal XML document', ECODE_MALLFORMED_REPLAY);
        }

        if ($xml->getName() !== 'response')
        {
            hd_print("Error: unexpected node '" . $xml->getName() . "'. Expected: 'response'");
            hd_print("XML-text: $doc.");
            throw new DunehdException('Invalid XML document', ECODE_MALLFORMED_REPLAY);
        }

        $xml_error = $xml->error;
        if ( empty($xml_error) )
            return $xml;

        $xml_code = strval($xml_error->code);
        $xml_desc = strval($xml_error->message);

		// fix frequently changed IP
		if(($xml_code == S_STIMEOUT || $xml_code == S_WRONG_IP) && $attempts < 3)
		{
			hd_print("Session error: $xml_code. Relogin attempt.");
			$bad_sid = $this->sid;
			$attempts++;
			try
			{
				$this->logout();
				$this->try_login($this->plugin_cookies, true);
				hd_print("sleep 5");
				sleep(5);
			}
			catch(Exception $e){hd_print("Relogin error: " . $e->message);}
			// replace SID
			$good_sid = $this->sid;
			$url = str_replace("sid=$bad_sid", "sid=$good_sid", $url);
			goto start;
		}
		
        $this->last_error = $xml_desc;

        hd_print("API error: URL '$url' returned error with code=$xml_code, msg=$xml_desc");
        if ($xml_code === S_UNKNOWN || $xml_code === '')
            throw new DunehdException('Unknown error', ECODE_ERROR, null, 'Unknown error');
        else
            throw new DunehdException($xml_code, ECODE_ERROR, null, $xml_desc);
    }

    ///////////////////////////////////////////////////////////////////////
    public function dune_api_exception($e, $def_caption, $is_playback)
    {
        $is_tptv_error = ($e instanceof DunehdException);
        if (!$is_tptv_error)
        {
            hd_print('General exception: ' . $e->getMessage());
            $title = !$is_playback ? 'Error' : 'Failed to connect to Internet';
            $text_lines = $is_playback ? array() : array('Failed to connect to Internet.', 'Please check Internet connection.');
            return new DuneException($def_caption, -1,
                ActionFactory::show_error(false, $title, $text_lines));
        }
        hd_print('API exception: ' . 'code=' . $e->getCode() . ', message=' . $e->getMessage() . ', desc= '. $e->description);

        $ecode = $e->getMessage();
        $fatal = $ecode == S_WRONG_IP || $ecode == S_ACC_WRONG ||
            $ecode == S_ACC_EMPTY || $ecode == S_ACC_NOSUB || $ecode == S_STIMEOUT ||
            $ecode == S_BAD_SID || $ecode == S_WRONG_SID || $ecode == S_URL_PROTECTED;

        if ($fatal)
            $this->logout();

        $this->login_incorrect = $ecode == S_ACC_EMPTY || $ecode == S_ACC_WRONG;

        $mess = $e->description;
        if ($mess === '')
            $mess = 'Description:' .  strval($ecode);
        $title = !$is_playback ? 'Error' : $mess;
        $text_lines = $is_playback ? array() : array($mess);

        return new DuneException(
                $def_caption, -1,
                ActionFactory::show_error($fatal, $title, $text_lines));
    }

    ///////////////////////////////////////////////////////////////////////////
    private function get_md5_pass($login,$pass)
    {
        $md5sum = md5(md5($login).md5($pass));
        return $md5sum;
    }

    private function api_login($user_name, $password, $for_play = true)
    {
        $this->user_name = $user_name;
        $this->login_error = null;
        try
        {
            //$this->get_mac_addr($mac_addr) = $mac_addr;
            $md5pass = $this->get_md5_pass($user_name, $password);
            $doc = API_HOST . "login?login=$user_name&pass=$md5pass&lng=" . $this->lang . "&user_agent=dune_" . HD::get_mac_addr($mac_addr) . "_v280116_" . $this->lang;
            hd_print("--->>> login: $doc");
            $xml = $this->xml_fetch($doc);
            $sid = $xml->sid;
            hd_print("--->>> sid: $sid");
            $this->sid = $sid;
            $this->is_logged = true;
            $this->login_incorrect = false;
            hd_print("--->>> is_logged: $this->is_logged");
        }
        catch (Exception $e)
        {
            $this->login_error = $this->last_error;
            throw $this->dune_api_exception($e, 'Login failed.', false);
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    public function api_get_account_info()
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_account_info?sid=$sid";
            hd_print("--->>> get_account_info: $doc");
            $this->account_info = $this->xml_fetch($doc);
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e, 'Error.', false);
        }
    }

    ///////////////////////////////////////////////////////////////////////////
    public function api_get_settings()
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_settings?sid=$sid";
            hd_print("--->>> get_settings_info: $doc");
            $this->settings = $this->xml_fetch($doc);
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e, 'Error.', false);
        }
    }
    public function api_get_quality()
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_quality_tv?sid=$sid";
            hd_print("--->>> get_quality_tv: $doc");
            $this->quality = $this->xml_fetch($doc);
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e, 'Error.', false);
        }
    }
///////////////////////////////////////////////////////////////////////////
    public function api_set_setting($param, $value)
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "set?sid=$sid&var=$param&val=$value";
//            hd_print("--->>> set_settings: $doc");
            $this->settings = $this->xml_fetch($doc);
			$this->settings = null;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e, 'Error.', false);
        }
    }
///////////////////////////////////////////////////////////////////////////
    public function api_change_pcode($old, $new)
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "set?sid=$sid&var=parental_pass&val=$new&protect_code=$old";
            //            hd_print("--->>> set_settings: $doc");
            $this->xml_fetch($doc);
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e, 'Error.', false);
        }
    }

///////////////////////////////////////////////////////////////////////////
    public function api_get_channels_tv(&$plugin_cookies)
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_list_tv?sid=$sid";
			if(isset($plugin_cookies->quality) and $plugin_cookies->quality == "lq")
				$doc .= "&quality=" . $plugin_cookies->quality;
            hd_print("--->>> get_list_tv: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e,
                'Channel list request failed.', false);
        }
    }

///////////////////////////////////////////////////////////////////////////

    public function api_get_groups_tv()
    {
        // check and set language
		try
		{
			$this->update_dune_config();
			if(!empty($this->lang))
			{
				if(empty($this->settings))
					$this->api_get_settings();
				if($this->settings->interface_lng != $this->lang)
				{
					$this->api_set_setting('interface_lng', $this->lang);
					$this->api_get_settings();
				}
			}
		}
		catch(Exception $e)
		{
			hd_print('Cant set language setting!!!');
		};
		
		try
        {
			$sid = $this->sid;
            $doc = API_HOST . "get_groups_tv?sid=$sid";
            hd_print("--->>> get_list_group: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e,
                'Channel list request failed.', false);
        }
    }

///////////////////////////////////////////////////////////////////////////
    public function check_for_arch()
    {
        $plugin_dir = DuneSystem::$properties['install_dir_path'];
        if (!file_exists('/tmp/arch/msdl'))
        {
            system("mkdir /tmp/arch",$return_var);
            system("cp $plugin_dir/msdl /tmp/arch/msdl",$return_var);
            system("chmod +x /tmp/arch/msdl", $return_var);
        }
        if (!file_exists('/tmp/arch/cgi-bin/arch'))
        {
            system("mkdir /tmp/arch/cgi-bin",$return_var);
            system("cp $plugin_dir/arch /tmp/arch/cgi-bin/arch",$return_var);
            system("chmod +x /tmp/arch/cgi-bin/arch", $return_var);
        }
        $hh = system('ps | grep httpd | grep -c /tmp/arch',$return_var);
        hd_print("var httpd:  $hh");
        if ( $hh <= 1)
        {
            system("httpd -h /tmp/arch -p 1000",$return_var);
        }
        return true;
    }

///////////////////////////////////////////////////////////////////////////
    public function api_get_url_tv($cid, $archive, $protect, $plugin_cookies)
    {
		try
        {
			if($this->settings == null)
				$this->api_get_settings();

            $sid = $this->sid;
            $doc = API_HOST . "get_url_tv?sid=$sid&cid=$cid";
            if (isset($protect) && $protect !== '')
            {
                $doc .= "&protect_code=$protect";
                hd_print("---> protected::$protect");
            }
            if (intval($archive) > 0)
            {
                if(intval($this->settings->time_shift))
					$archive = intval($archive) - intval($this->settings->time_shift) * 3600;
				$doc .= "&uts=$archive";
                hd_print("---> arch::$archive");
            }
			if(isset($plugin_cookies->quality))
			{
                $doc .= "&quality=" . $plugin_cookies->quality;
			}
			if(intval($this->settings->time_shift) > 0 and intval($archive) <= 0)
			{
				$doc .= "&time_shift=" . intval($this->settings->time_shift);
			}
            hd_print("---> get_url_tv: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e,
                'Get url for playback failed.', true);
        }
	}

///////////////////////////////////////////////////////////////////////////
    public function api_get_epg($day_start, $channel_id)
    {
        try
        {
            if($this->settings == NULL)
				$this->api_get_settings();

			$sid = $this->sid;
            $doc = API_HOST . "get_epg?sid=$sid&cid=$channel_id&from_uts=$day_start&hours=24";
			// API не поддерживает одновременно from_uts и time_shift
			//if(intval($this->settings->time_shift))
			//	$doc .= "&time_shift=" . intval($this->settings->time_shift);
            hd_print("--->>> epg: $doc");

            $xml = $this->xml_fetch($doc);
            if ($xml->channels->getName() !== 'channels')
            {
                hd_print("Error: unexpected node '" . $xml->channels->getName() . "'. Expected: 'channels'");
                throw new Exception('Invalid XML document');
            }
			
			$timeshift_sec = intval($this->settings->time_shift) * 3600;
			foreach($xml->channels->children() as $channel)
				foreach($channel->epg->children() as $item)
				{
					$item->begin[0] = intval($item->begin) + $timeshift_sec;
					$item->end[0] = intval($item->end) + $timeshift_sec;
				}

            return $xml;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e,
                'Get epg failed.', false);
        }
    }

    ///////////////////
    /// VOD

    public function api_get_list_movie($page, $nums, $extended, $genre, $lang, $word, $year, $idlist, $type, $parent = null)
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_list_movie?sid=$sid&page=$page&limit=$nums&extended=$extended";
            if ($genre != null)
                $doc .= "&genre=$genre";
            if ($lang != null)
                $doc .= "&lang=$lang";
            if ($word != null)
                $doc .= "&word=$word";
            if ($year != null)
                $doc .= "&year=$year";
            if ($idlist != null)
                $doc .= "&idlist=$idlist";
            if ($type != null and $type != "1")
                $doc .= "&type=$type";
            if ($parent != null)
                $doc .= "&parent=$parent";

            hd_print("--->>> get_list_movie: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
            throw $this->dune_api_exception($e,
                'get_list_movie failed', false);
        }
    }

    public function api_vod_info($movie_id, $movie_type = null)
    {
        hd_print("####### api_vod_info($movie_id, $movie_type)");
		//hd_print(debug_print_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS));
		$doc = $this->api_get_list_movie(1, 1, 1, null, null, null, null, $movie_id, $movie_type);
        $item = $doc->groups->item;
		
		if(empty($item))
		{
			// serial ?
			$doc = $this->api_get_list_movie(1, 1, 1, null, null, null, null, $movie_id, 6);
			$item = $doc->groups->item;
		}
		
		if(empty($item))
		{
			// collection ?
			$doc = $this->api_get_list_movie(1, 1, 1, null, null, null, null, $movie_id, 5);
			$item = $doc->groups->item;
		}
		
		if(empty($item))
		{
			// serie ?
			$doc = $this->api_get_list_movie(1, 1, 1, null, null, null, null, $movie_id, 4);
			$item = $doc->groups->item;
		}
			
		if(empty($item))
		{
			// season ?
			$doc = $this->api_get_list_movie(1, 1, 1, null, null, null, null, $movie_id, 3);
			$item = $doc->groups->item;
		}
		
			if (empty($item))
			return null;

		$movie = new DunehdMovie($movie_id);
		$movie->set_data(
			$item->title,
			null,
			$item->description,
			$item->pic,
			$item->time/60,
			$item->year,
			null,
			null,
			null,
			$item->genre,
			null,
			null,
			null,
			null,
			null);
			
		$movie->movie_type = intval($item->type->__toString());
		if($item->seasons != 0)
			$movie->seasons = 1;
				
		if($item->type == 5 or $item->type == 6 or $item->type == 3)
		{
			$page = 1;
			$limit = 100; // 100 is max value
			while(true)
			{
				$doc = $this->api_get_list_movie($page, $limit, 1, null, null, null, null, null, null, $movie_id);
				foreach($item = $doc->groups->item as $item)
				{
					if($item->type == 4 || $item->type == 3)
						$movie->add_series_data(
							$item->id,
							$item->title,
							strval($item->id),
							false);
					// у некоторых сералов есть сезон, но метка сезонов не установлена
					if($item->type == 3)
						$movie->seasons = 1;
				}
				if($doc->options->count > $page*$limit)
					$page++;
				else
					break;
			}
		}
		else
		{
			$movie->add_series_data(
				$item->id,
				$item->title,
				strval($item->id),
				false);
		}

        return $movie;
    }

    public function api_get_genre_movie()
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_genre_movie?sid=$sid";
            hd_print("--->>> get_genre_movie: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
			throw $this->dune_api_exception($e,
                'get_genre_movie', false);
        }
    }

    public function api_get_url_movie($cid, $protect_code = null)
    {
        try
        {
            $sid = $this->sid;
            $doc = API_HOST . "get_url_movie?sid=$sid&cid=$cid";
			if($protect_code != null)
				$doc .= "&protect_code=$protect_code";
            hd_print("--->>> get_url_movie: $doc");
            $xml = $this->xml_fetch($doc);
            return $xml;
        }
        catch (Exception $e)
        {
            $ecode = $e->getMessage();
			hd_print("api_get_url_movie  error code: $ecode");
			if($ecode === S_URL_PROTECTED) 
				throw $e;
				
            throw $this->dune_api_exception($e,
                'get_url_movie', false);
        }
    }

    //////////////////////////////////////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////

    public function try_login(&$plugin_cookies, $for_play = true)
    {
        hd_print('*** try_login()');
        if (!isset($plugin_cookies->user_name))
            throw new Exception('User name is not set');

		$this->plugin_cookies = $plugin_cookies;
        try
        {
            $this->api_login(
                $plugin_cookies->user_name,
                $plugin_cookies->password,
                $for_play);

/*
			$cmd = 'killall noop';
			hd_print("starting: $cmd");
			$s = system($cmd);
			if (!empty($s))
				hd_print("$cmd - $s");

			$cmd = 'chmod +x '. DuneSystem::$properties['install_dir_path'] . '/noop';
			$s = system($cmd);
			if (!empty($s))
				hd_print("$cmd - $s");

			$cmd = DuneSystem::$properties['install_dir_path'] . '/noop ' . API_HOST . 'noop?sid=' . $this->sid;
			hd_print("starting: $cmd");
			$s = shell_exec("nohup $cmd > /dev/null & echo $!");
			if (!empty($s))
				hd_print("$cmd - $s");
	*/			
        }
        catch (Exception $e)
        {
            hd_print('*** try_login() - exception');
            $this->logout();
            throw $e;
        }
    }

    public function ensure_logged_in(&$plugin_cookies)
    {
        hd_print("*** ensure_logged_in() is_logged: $this->is_logged");
        if ($this->is_logged)
            return;

        $this->logout();

        $this->try_login($plugin_cookies);
    }

    public function check_logged_in()
    {
        if (!$this->is_logged)
            throw new DunehdException('Not logged in', ECODE_ERROR);
    }

    public function check_authorization(&$plugin_cookies, $for_play)
    {
        hd_print('*** check_authorization()');
        try
        {
            $this->api_login(
                $plugin_cookies->user_name,
                $plugin_cookies->password,
                $for_play);
        }
        catch (Exception $e)
        {
            $this->logout();
            return false;
        }

        return $this->logged_in;
    }

    public function get_sid()
    {
        if (!$this->is_logged)
            throw new DunehdException('Not logged in', ECODE_ERROR, nil, S_WRONG_SID);
        return $this->sid;
    }

    ///////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////
    /// Subscribtion Dialog

    private function do_get_edit_subscription_defs(&$plugin_cookies, $handler, $add_params)
    {
        $defs = array();

        $user_name = isset($plugin_cookies->user_name) ? $plugin_cookies->user_name : '';
        $password = isset($plugin_cookies->password) ? $plugin_cookies->password : '';

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'user_name', $this->translate('login'),
            $user_name, true, false, false, false, 400);

        ControlFactory::add_text_field($defs,
            $handler, $add_params,
            'password', $this->translate('password'),
            $password, true, true, false, false, 400);

        ControlFactory::add_vgap($defs, 50);

        ControlFactory::add_button($defs,
            $handler, $add_params,
            'apply_subscription', null, $this->translate('enter'), 300);

        ControlFactory::add_vgap($defs, -3);

        ControlFactory::add_close_dialog_button($defs,
            $this->translate('cancel'), 300);

        return $defs;
    }

    public function do_get_edit_subscription_action(
        &$plugin_cookies, $handler, $add_params = null)
    {
        return ActionFactory::show_dialog(
            $this->translate('subscription_data'),
            $this->do_get_edit_subscription_defs(
                $plugin_cookies, $handler, $add_params),
            true);
    }

    public function apply_subscription(&$plugin_cookies, &$user_input)
    {
        if (!isset($user_input->control_id) ||
            $user_input->control_id != 'apply_subscription')
        {
            hd_print('*** apply_subscription() - false');
            return false;
        }

        hd_print("*** apply_subscription()");
        if ($user_input->user_name === '')
        {
            return array(
                'need_close_dialog' => false,
                'action' =>
                ActionFactory::show_error(false,
                    'Error',
                    array('Subscription should be non-empty.')));
        }

        $plugin_cookies->user_name = $user_input->user_name;
        $plugin_cookies->password = $user_input->password;

        $this->logout();

        $post_action = null;
        try
        {
            $this->try_login($plugin_cookies);
        }
        catch (DuneException $e)
        {
            $post_action = $e->get_error_action();
        }

        return array(
            'need_close_dialog' => true,
            'action' => $post_action);
    }
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
    public function logout_Dunehd($sid)
    {
        $doc = API_HOST . "logout?sid=$sid";
        hd_print("--->>> logout: $doc");
        $xml = $this->xml_fetch($doc);
        $message = $xml->message;
        hd_print("--->>> logout message: $message");
    }
///////////////////////////////////////////////////////////////////////////
    public function noop_Dunehd($sid)
    {
        $doc = API_HOST . "noop?sid=$sid";
        hd_print("--->>> is login in server: $doc");
        $xml = $this->xml_fetch($doc);
        $message = strval($xml->message);
        hd_print("--->>> is login in server: $message");
        return $message;
    }
	
	public function update_dune_config()
	{
		$l = null; $tz = null;
        CrackDuneConfig($l, $tz);
		switch($l)
		{
			case 'russian': $this->lang = 'ru'; break;
			case 'polish': $this->lang = 'pl'; break;
			case 'english': $this->lang = 'en'; break;
			case 'turkish': $this->lang = 'tr'; break;
			case 'german': $this->lang = 'de'; break;
		}
	}

	public function translate($key)
	{
		$lang = $this->get_dune_lang();
		return DunehdConfig::get_str($lang, $key);
	}

}
///////////////////////////////////////////////////////////////////////////
function CrackDuneConfig(& $lang, & $tz)
{

    $s = shell_exec('cat /config/settings.properties');
    if (empty($s))
        return;
    $arr = explode("\n", $s);
    foreach ($arr as $line)
    {
        $a2 = explode('=', $line, 2);
        if (isset($a2[0]) && isset($a2[1]))
        {
            $param = trim($a2[0]);
            if(!isset($lang) && $param == 'interface_language')
            {
                $lang = trim($a2[1]);
            }
            else if (!isset($tz) && $param == 'time_zone')
            {
                $a2_2 = explode(':', trim($a2[1]), 2);
                if (isset($a2_2[0]) && is_numeric($a2_2[0]))
                    $tz = -$a2_2[0];
            }
        }
        if (isset($lang) && isset($tz))
        {
            hd_print("Crack config --> $lang $tz");
            return;
        }
    }
}

?>
